package com.digiwin.athena.semc.entity.fineReport;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 帆软参数配置表实体类
 *
 * @author sungqz
 * @since 2025-08-11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_fine_report_auth")
public class FineReportAuth implements Serializable {

    private static final long serialVersionUID = -2962678949998701835L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 权限对象sid，例：组织sid、角色sid、用户sid
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限对象id，例：组织id、角色id、用户id
     */
    @TableField(value = "auth_biz_id")
    private String authBizId;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @TableField(value = "auth_type")
    private Integer authType;

    /**
     * 全员可见 0:否 1:是
     */
    @TableField(value = "all_auth_flag")
    private Integer allAuthFlag;

    /**
     * 帆软报表id，即帆软接口返回的报表id
     */
    @TableField(value = "fine_report_id")
    private String fineReportId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 创建者账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    private String createUserId;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    private String createTime;
}