package com.digiwin.athena.semc.entity.fineReport;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * 帆软用户映射关系实体类
 *
 * @author sungqz
 * @since 2025-08-11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_fine_report_user_mapping")
public class FineReportUserMapping implements Serializable {

    private static final long serialVersionUID = 878904155044205736L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 雅典娜用户账号
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 雅典娜用户名称
     */
    @TableField(value = "user_name")
    private String userName;

    /**
     * 帆软用户账号
     */
    @TableField(value = "fr_user_id")
    private String frUserId;

    /**
     * 帆软用户名称
     */
    @TableField(value = "fr_user_name")
    private String frUserName;

    /**
     * 帆软用户密码
     */
    @TableField(value = "fr_user_pwd")
    private String frUserPwd;

    /**
     * 帆软用户邮箱
     */
    @TableField(value = "fr_user_email")
    private String frUserEmail;

    /**
     * 帆软用户手机号
     */
    @TableField(value = "fr_user_mobile")
    private String frUserMobile;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time", fill = FieldFill.INSERT_UPDATE)
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String modifyUserId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}