package com.digiwin.athena.semc.entity.homepage;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 已读广告记录表
 */
@Data
@TableName(value = "t_read_advertisement")
public class ReadAdvertisement extends BaseEntity<ReadAdvertisement> implements Serializable {

    private static final long serialVersionUID = -8560745495935240832L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 广告id
     */
    @TableField(value = "advertisement_id")
    private Long advertisementId;

    /**
     * 广告标题
     */
    @TableField(value = "advertisement_title")
    private String advertisementTitle;

    /**
     * 重要性 0：不重要 1：重要
     */
    @TableField(value = "importance_flag")
    private Integer importanceFlag;

    /**
     * 浏览次数
     */
    @TableField(value = "read_count")
    private Integer readCount;

    /**
     * 读取日期_年月日
     */
    @TableField(value = "read_date")
    private String readDate;

    /**
     * 读取日期_时分秒
     */
    @TableField(value = "read_time")
    private String readTime;

    /**
     * 首次浏览平台 entrance：智能入口 tbb：tbb
     */
    @TableField(value = "first_read_platform")
    private String firstReadPlatform;

    /**
     * 阅读人员名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}