package com.digiwin.athena.semc.entity.homepage;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.news.NewsAnnouncement;
import lombok.*;

import java.io.Serializable;

/**
 * 租户门户类型表(TenantPortalRecord)实体类
 *
 * @author sungqz
 * @since 2024-05-24
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "tenant_portal_record")
public class TenantPortalRecord extends BaseEntity<NewsAnnouncement> implements Serializable {
    private static final long serialVersionUID = -3646853814298395177L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 门户类型 0:极简门户 1:经典门户
     */
    @TableField(value = "portal_type")
    private Integer portalType;

    /**
     * 是否使用最近一次的门户 0:否 1:是
     */
    @TableField(value = "use_latest_flag")
    private Integer useLatestFlag;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

