package com.digiwin.athena.semc.entity.homepage;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户门户风格记录表
 */
@Data
@TableName(value = "user_portal_record")
public class UserPortalRecord extends BaseEntity<UserPortalRecord> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 最近一次门户类型 0:极简门户 1:传统门户
     */
    private Integer portalType;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 租户sid
     */
    private long tenantSid;
}