package com.digiwin.athena.semc.entity.machine;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


import java.io.Serializable;

/**
 * 绿色智机预设的模组和作业
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_topic_preset")
public class TopicPreset extends BaseEntity<TopicPreset> implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /***
     *
     *点击次数
     */
    private String topicPresetId;
    /***
     * url+多语言
     */
    private String presetContent;
    /***
     * 标题
     */
    private String title;

    /***
     * 公司菜单
     */
    private String companyMenuId;
    /**
     * 自定义图片url（icon)
     */
    private String customPicId;

    /***
     * 租户id
     */
    private String tenantId;

    /***
     * 应用：0,作业：1
     */
    private Integer type;
}

