package com.digiwin.athena.semc.entity.machine;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：公司工厂类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UserCompanyFactory.java
 * @Author: wangjwc
 * @Date: created at 2025/9/8 10:17
 */
@Data
public class UserCompanyFactory implements Serializable {
    private static final long serialVersionUID = -4902159540262015321L;

    private Long sid;

    private String id;

    private String type;

    private String title;
    // 是否选中
    private Boolean selected = false;

    private List<UserCompanyFactory> children;

    public UserCompanyFactory() {
    }

    public UserCompanyFactory(Long sid, String id, String type, String title) {
        this.sid = sid;
        this.id = id;
        this.type = type;
        this.title = title;
    }

    public UserCompanyFactory(Long sid, String id, String type, String title, List<UserCompanyFactory> children) {
        this(sid, id, type, title);
        this.children = children;
    }
}
