package com.digiwin.athena.semc.entity.menu;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 自定义菜单模板表(TCustomizedMenuTemplate)实体类
 *
 * @author sungqz
 * @since 2023-11-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_customized_menu_template")
public class CustomizedMenuTemplate extends BaseEntity<CustomizedMenuTemplate> implements Serializable {
    private static final long serialVersionUID = -84813003997289290L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 菜单设计时id
     */
    @TableField(value = "menu_designer_id")
    private Long menuDesignerId;

    /**
     * 模板名称
     */
    @TableField(value = "template_name")
    private String templateName;

    /**
     * 模板名称_繁体
     */
    @TableField(value = "template_name_tw")
    private String templateNameTw;

    /**
     * 模板描述
     */
    @TableField(value = "template_desc")
    private String templateDesc;

    /**
     * 模板状态 0:未发布 1:已发布
     */
    @TableField(value = "template_status")
    private Integer templateStatus;

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    @TableField(value = "general_flag")
    private Integer generalFlag;

    /**
     * 是否展示系统菜单 0:否 1:是
     */
    @TableField(value = "system_menu_flag")
    private Integer systemMenuFlag;

    /**
     * 创建人名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 更新人名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;

    /**
     * 关联的门户名称
     */
    @TableField(exist = false)
    private List<String> portalList;

    /**
     * 是否关联当前门户 true:关联 false：未关联
     */
    @TableField(exist = false)
    private Boolean relatedFlag = Boolean.FALSE;

    /**
     * 数据版本，如：1.0、2.0
     */
    @TableField(value = "version")
    private String version;

    /**
     * 编辑版本
     */
    @TableField(value = "compile_version")
    private String compileVersion;

    /**
     * 发布来源 ISV TENANT
     */
    @TableField(value = "publish_source")
    private String publishSource;

    /**
     * 工作台应用code
     */
    @TableField(value = "workbench_app_code")
    private String workbenchAppCode;

    @TableField(value = "source")
    private Integer source;

    /**
     * 门户Id（复制ISV门户时复制的菜单需绑定当前的门户Id）
     */
    @TableField(value="portal_id")
    private Long portalId;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;
}