package com.digiwin.athena.semc.entity.menu;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 自定义菜单作业表(TCustomizedMenuWork)实体类
 *
 * @author sungqz
 * @since 2023-11-10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_customized_menu")
public class CustomizedMenuWork extends BaseEntity<CustomizedMenuWork> implements Serializable {
    private static final long serialVersionUID = -19210737024095755L;
    /**
     * 主键id
     */
    @TableId()
    private Long id;

    /**
     * 模板id
     */
    @TableField(value = "template_id")
    private Long templateId;

    /**
     * 菜单图标
     */
    @TableField(value = "menu_icon")
    private String menuIcon;

    /**
     * 菜单/作业/组件名称
     */
    @TableField(value = "menu_name")
    private String menuName;

    /**
     * 菜单/作业/组件初始名称
     */
    @TableField(value = "original_name")
    private String originalName;

    /**
     * 菜单/作业/组件繁体名称
     */
    @TableField(value = "menu_name_tw")
    private String menuNameTw;

    /**
     * 类型 1:菜单 2:作业 3:组件
     */
    @TableField(value = "menu_type")
    private Integer menuType;
    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    @TableField(value = "label_type_source")
    private Integer labelTypeSource;
    /**
     * 组件id
     */
    @TableField(value = "menu_label_id")
    private Long menuLabelId;

    /**
     * 组件类型 0:自定义组件 1:预设组件
     */
    @TableField(value = "menu_label_type")
    private Integer menuLabelType;

    /**
     * 应用编码
     */
    @TableField(value = "app_code")
    private String AppCode;

    /**
     * 应用作业配置
     */
    @TableField(value = "work_config")
    private String workConfig;

    /**
     * 层级 1:一级 2:二级 3:三级
     */
    @TableField(value = "menu_level")
    private Integer level;

    /**
     * 顺序
     */
    @TableField(value = "menu_order")
    private Integer menuOrder;

    /**
     * 父级id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 父级名称
     */
    @TableField(value = "parent_name")
    private String parentName;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 预设组件类型 2：新闻公告、3：邮件、4：常用、5：收藏、6：数智视图、7：绩效、8：作业工作台、9：行事历
     */
    @TableField(exist = false)
    private Integer preLabelDataType;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    @TableField(value = "data_type")
    private Integer dataType;

    @TableField(value = "workbench_app_code")
    private String workbenchAppCode;

    @TableField(value = "version")
    private String version;

    /**
     * 设计态模板id
     */
    @TableField(value = "des_template_id")
    private Long desTemplateId;
}