package com.digiwin.athena.semc.entity.menu.manage;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;
import java.util.List;

import javax.validation.constraints.NotBlank;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 管理后台基础菜单配置表(TManageMenu)实体类
 *
 * @author sungqz
 * @since 2024-09-30
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_manage_menu")
public class ManageMenu extends BaseEntity<ManageMenuAuth> implements Serializable {

    private static final long serialVersionUID = 521868852629055983L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 菜单key，每个菜单项的唯一标识符
     */
    @NotBlank(message = "the menuKey can not be null")
    private String menuKey;
    /**
     * 菜单类型 1:菜单 2:外链 3:iframe
     */
    private Integer menuType;
    /**
     * 菜单项的大陆显示名称
     */
    private String menuNameCn;
    /**
     * 菜单项的台湾显示名称
     */
    private String menuNameTw;
    /**
     * 菜单项的英文显示名称
     */
    private String menuNameUs;
    /**
     * 父菜单id
     */
    private Long parentId;
    /**
     * 父菜单key
     */
    private String parentMenuKey;
    /**
     * 菜单项的图标，可以是一个URL或图标名称
     */
    private String menuIcon;
    /**
     * 路由标题
     */
    private String routeTitle;
    /**
     * 路由关键字，唯一
     */
    private String routeKey;
    /**
     * 路由路径：菜单项对应的前端路由路径
     */
    private String routePath;
    /**
     * 路由重定向：默认跳转地址
     */
    private String routeRedirect;
    /**
     * 打开方式 1:当前页 2:新开页面
     */
    private Integer openType;
    /**
     * 扩展参数
     */
    private String extendParams;
    /**
     * 外链的链接地址
     */
    private String outsideLinkUrl;
    /**
     * 排序值，用于确定菜单在列表中的显示顺序
     */
    private Integer menuSort;
    /**
     * 是否缓存，用于页面是否缓存（预留）0:否 1:是
     */
    private Integer cachedFlag;
    /**
     * 是否可见，控制菜单是否在前端显示 0:否 1:是
     */
    private Integer visibleFlag;
    /**
     * 是否是二级页面 0:否 1:是
     */
    private Integer secondPageFlag;
    /**
     * 是否禁用，控制菜单是否可以点击 0:否 1:是
     */
    private Integer disabledFlag;
    /**
     * 所属环境标识 0:全部 1:云上 2:下地
     */
    private Integer belongingEnvironmentFlag;
    /**
     * 所属用户id列表，表示仅对当前用户可见
     */
    private String belongingUsers;
    /**
     * 备注
     */
    private String remark;
    /**
     * 扩展字段1
     */
    private String extendFieldOne;
    /**
     * 扩展字段2
     */
    private String extendFieldTwo;
    /**
     * 扩展字段3
     */
    private String extendFieldThird;
    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 菜单版本标识
     */
    @TableField(value="version",updateStrategy = FieldStrategy.IGNORED)
    private String version;

    /**
     * 菜单访问区域，0全部区域可访问，1只有预区可访问
     */
    private Integer onlyPreArea;

    /**
     * 子菜单列表
     */
    @TableField(exist = false)
    private List<ManageMenu> childrenList;
}

