package com.digiwin.athena.semc.entity.menu.manage;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 管理后台菜单权限表实体类
 *
 * @author sungqz
 * @since 2024-08-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_manage_menu_auth")
public class ManageMenuAuth extends BaseEntity<ManageMenuAuth> implements Serializable {

    private static final long serialVersionUID = 2055371351146417189L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 菜单标识
     */
    @TableField(value = "menu_key")
    private String menuKey;

    /**
     * 全部菜单权限标识 0:否 1:是
     */
    @TableField(value = "all_menu_auth_flag")
    private Integer allMenuAuthFlag;

    /**
     * 权限对象id
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @TableField(value = "auth_type")
    private Integer authType;

    /**
     * 租户id
     */
    private String tenantId;
}