package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.util.Date;
import java.io.Serializable;

/**
 * 邮件关联人员表(TEmailTemplateRel)实体类
 *
 * @author sungqz
 * @since 2024-01-09
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_email_template_rel")
public class EmailTemplateRel extends BaseEntity<EmailTemplateRel> implements Serializable {
    private static final long serialVersionUID = 876264343870173966L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模板主键id
     */
    private Long templateId;

    /**
     * om平台事件id
     */
    private String eventId;
    /**
     * 语言别
     */
    private String language;
    /**
     * 收件人类型 1：收件人 2：抄送人 3：密送人
     */
    private Integer emailType;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 收件人邮箱
     */
    private String contact;
    /**
     * 租户id
     */
    private String tenantId;
}

