package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.util.Date;
import java.io.Serializable;

/**
 * 消息接收人黑白名单(TMessageBlackWhite)实体类
 *
 * @author sungqz
 * @since 2024-01-10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_message_black_white")
public class MessageBlackWhite extends BaseEntity<EmailTemplateRel> implements Serializable {
    private static final long serialVersionUID = -93724301532388971L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 用户sid
     */
    private String userSid;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 名单类型 0:黑名单 1:白名单
     */
    private Integer type;
    /**
     * 租户id
     */
    private String tenantId;
}

