package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 消息发送渠道表(TMessageChannel)实体类
 *
 * @author sungqz
 * @since 2023-11-30
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_message_channel")
public class MessageChannel extends BaseEntity<MessageChannel> implements Serializable {
    private static final long serialVersionUID = -77787862239860140L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 消息渠道标识 wecom:企业微信
     */
    @TableField(value = "channel_flag")
    private String channelFlag;

    /**
     * 消息渠道应用级别 1:租户级 2:用户级
     */
    @TableField(value = "channel_level")
    private Integer channelLevel;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

