package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 消息发送渠道基础表(TMessageChannel)实体类
 *
 * @author sungqz
 * @since 2023-12-1
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_message_channel_base")
public class MessageChannelBase extends BaseEntity<MessageChannelBase> implements Serializable {

    private static final long serialVersionUID = 6799212684616798448L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 消息渠道标识
     */
    @TableField(value = "channel_key")
    private String channelKey;

    /**
     * 消息渠道名称
     */
    @TableField(value = "channel_value")
    private String channelValue;

    /**
     * 消息渠道名称_繁体
     */
    @TableField(value = "channel_value_tw")
    private String channelValueTw;
}

