package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 消息模板配置表实体类
 *
 * @author sungqz
 * @since 2024-1-8
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_message_channel_template")
public class MessageChannelTemplate extends BaseEntity<MessageChannelTemplate> implements Serializable {

    private static final long serialVersionUID = 9158687428102352406L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * om平台事件id
     */
    @TableField(value = "event_id")
    private String eventId;

    /**
     * 模板备注，om平台事件备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 模板状态 0:停用 1:启用
     */
    @TableField(value = "valid_status")
    private Integer validStatus;

    /**
     * 渠道标识 email:邮件 sms:短信 wecom:企微 dingding:钉钉
     */
    @TableField(value = "channel_flag")
    private String channelFlag;

    /**
     * 父级ID
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 更新者名称
     */
    @TableField(value = "modify_user_name")
    private String modifyUserName;
}

