package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.util.Date;
import java.io.Serializable;

/**
 * 短信关联人员表(TSmsTemplateRel)实体类
 *
 * @author sungqz
 * @since 2024-01-09
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_sms_template_rel")
public class SmsTemplateRel extends BaseEntity<SmsTemplateRel> implements Serializable {
    private static final long serialVersionUID = 502273642082295015L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * om平台事件id
     */
    private String eventId;
    /**
     * 语言别
     */
    private String language;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 收件人手机号
     */
    private String telephone;
    /**
     * 租户id
     */
    private String tenantId;
}

