package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.io.Serializable;

/**
 * 三方消息用户保存的应用顺序
 *
 * @author sungqz
 * @since 2025-06-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_message_app_sort")
public class ThirdMessageAppSort implements Serializable {

    private static final long serialVersionUID = 7001649207387410118L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用id，sso配置中的appId值
     */
    private String appId;

    /**
     * 应用顺序
     */
    private Integer appSort;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建时间
     */
    private String createTime;
}

