package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 异构系统消息接入配置表(TThirdMessageConfig)实体类
 *
 * @author sungqz
 * @since 2024-03-04
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_message_config")
public class ThirdMessageConfig extends BaseEntity<ThirdMessageConfig> implements Serializable {

    private static final long serialVersionUID = 197028986948020865L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用主键id
     */
    private String appPrimaryId;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    private Integer appSource;

    /**
     * 应用注册时生成的appId
     */
    private String applicationAppId;

    /**
     * 配置描述
     */
    private String configDesc;

    /**
     * 应用名称
     */
    @TableField(exist = false)
    private String appName;

    /**
     * 数据获取方式 1:应用推送数据 2:拉取应用数据
     */
    private Integer dataGetType;

    /**
     * 拉取数据频率,单位秒
     */
    private Integer pullPeriod;

    /**
     * 应用接入模式 0:混合云 1:非混合云
     */
    private Integer appAccessModel;

    /**
     * 地中台产品名称
     */
    private String middleSystemName;

    /**
     * 地中台产品uid
     */
    private String middleSystemUid;

    /**
     * 应用域名
     */
    @TableField(value = "`domain`")
    private String domain;

    /**
     * 发送渠道，逗号分割，如：wecom,dingding
     */
    private String sendChannel;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 租户id
     */
    private String tenantId;
}

