package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.io.Serializable;

/**
 * 异构系统消息表(TThirdMessageInfo)实体类
 *
 * @author sungqz
 * @since 2024-03-05
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_message_info")
public class ThirdMessageInfo implements Serializable {
    private static final long serialVersionUID = -20441200628843632L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 消息来源应用code
     */
    private String messageAppCode;

    /**
     * 消息来源应用id
     */
    private String messageAppId;

    /**
     * 消息id
     */
    private String messageId;

    /**
     * 消息所有者(异构系统用户id),全员可看的消息该字段存all
     */
    private String messageOwner;

    /**
     * 消息标题
     */
    private String messageTitle;

    /**
     * 消息内容
     */
    private String messageContent;

   /* *//**
     * 消息详情跳转参数
     *//*
    private String messageDetailParam;*/

    /**
     * 消息跳转完整链接
     */
    private String messageUrl;

    /**
     * 移动消息跳转完整链接
     */
    private String mobileMessageUrl;

    /**
     * 消息发布时间
     */
    private String messagePublishTime;

    /**
     * 账套id
     */
    private String accountId;

    /**
     * 账套名称
     */
    private String accountName;

    /**
     * 是否全员可看 1:全员可阅 0:部分成员可阅读
     */
    @TableField(exist = false)
    private Integer messageAllStaffRead;

    /**
     * 是否显示小红点 true：是 false：否
     */
    @TableField(exist = false)
    private Boolean isRed = Boolean.TRUE;

    /**
     * 注册应用时生成的appId
     */
    @TableField(exist = false)
    private String applicationAppId;

    /**
     * 消息来源应用名称
     */
    @TableField(exist = false)
    private String messageAppName;

    /**
     * 回调地址
     */
    @TableField(exist = false)
    private String callBackUrl;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    @TableField(exist = false)
    private Integer protocolType;

    /**
     * appToken
     */
    @TableField(exist = false)
    private String appToken;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 更新时间
     */
    private String modifyTime;

    /**
     * 消息分类code
     */
    private String messageTypeCode;

    /**
     * 消息分类名称
     */
    @TableField(exist = false)
    private String messageTypeName;

    /**
     *  0 pc消息 2 pc且移动消息  1 移动消息
     */
    @TableField(value = "side_type")
    private Integer sideType;
}

