package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.io.Serializable;

/**
 * 异构系统消息读取表(TThirdMessageReadInfo)实体类
 *
 * @author sungqz
 * @since 2024-03-07
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_message_read_info")
public class ThirdMessageReadInfo implements Serializable {
    private static final long serialVersionUID = 194751258793104874L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 消息id
     */
    private String messageId;

    /**
     * 应用id
     */
    private String messageAppId;

    /**
     * 消息来源
     */
    private String messageAppCode;

    /**
     * 读取者(iam-userid)
     */
    private String readUser;

    /**
     * 用户账号(异构系统用户id)
     */
    private String readSourceUser;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 租户id
     */
    private String tenantId;
}

