package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.*;

import java.io.Serializable;

/**
 * 三方消息分类
 *
 * @author sungqz
 * @since 2025-06-26
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_third_message_type")
public class ThirdMessageType implements Serializable {

    private static final long serialVersionUID = 5821010600781964413L;

    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 消息分类code
     */
    private String messageTypeCode;

    /**
     * 消息分类名称
     */
    private String messageTypeName;

    /**
     * 创建时间
     */
    private String createTime;
}

