package com.digiwin.athena.semc.entity.message;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.util.Date;
import java.io.Serializable;

/**
 * 企微关联人员表(TWecomTemplateRel)实体类
 *
 * @author sunqgz
 * @since 2024-01-09
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_wecom_template_rel")
public class WecomTemplateRel extends BaseEntity<WecomTemplateRel> implements Serializable {
    private static final long serialVersionUID = 584525899075653211L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * om平台事件id
     */
    private String eventId;
    /**
     * 语言别
     */
    private String language;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 租户id
     */
    private String tenantId;
}

