package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName(value = "t_mobile_application_column")
public class MobileApplicatonColumn extends BaseEntity<MobileApplicatonColumn> {
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 上级id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 名称
     */
    @TableField(value = "name",updateStrategy = FieldStrategy.IGNORED)
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 是否展示栏目名称
     */
    @TableField(value = "is_name_show")
    private Integer isNameShow;

    /**
     * 排序id
     */
    @TableField(value = "order_id")
    private Integer orderId;

    /**
     * 自定义应用id
     */
    @TableField(value = "custom_app_id")
    private Long customApplicationId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;


}
