package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by changcong 21064
 * Date 2025/9/5 13:58
 * Description
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName(value = "t_mobile_application_column_new")
public class MobileApplicatonColumnNew extends BaseEntity<MobileApplicatonColumnNew> {
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 上级id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 名称
     */
    @TableField(value = "name",updateStrategy = FieldStrategy.IGNORED)
    private String name;

    /**
     * 状态：0：停运、1：启用
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 是否展示栏目名称
     */
    @TableField(value = "is_name_show")
    private Integer isNameShow;

    /**
     * 排序id
     */
    @TableField(value = "order_id")
    private Integer orderId;

    /**
     * 自定义应用id
     */
    @TableField(value = "custom_app_id")
    private String customApplicationId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 来源
     */
    @TableField(value = "source")
    private Integer source;

    /**
     * 模组id
     */
    @TableField(value = "module_id")
    private String moduleId;
}
