package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
* 移动应用/作业权限关系表
* @TableName
*/

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_datasource_auth")
public class MobileDataSourceAuth extends BaseEntity<MobileDataSourceAuth> implements Serializable {

    /**
    * 主键
    */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
    * 权限对象id
    */
    private String authId;

    /**
     * 权限对象id
     */
    private Long authSid;

    /**
    * 权限对象名称
    */
    private String authName;

    /**
    * 权限类型：1.组织 2.角色 3.用户
    */
    private Integer authType;

    /**
    * 应用-作业ID
    */
    private Long datasourceId;

    /**
    * 租户id
    */
    private String tenantId;

}
