package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 分类表
 *
 * @author sungqz
 * @since 2024-05-13
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_mobile_datasource_classification")
public class MobileDatasourceClassification extends BaseEntity<MobileDatasourceClassification> implements Serializable {
    private static final long serialVersionUID = 791829292787947929L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 分类名称
     */
    @NotBlank(message = "the name cannot be null")
    @Length(max = 20, message = "the length of name cannot over 20")
    @TableField(value = "classification_name")
    private String classificationName;

    /**
     * 权重,越小越靠前
     */
    @TableField(value = "priority")
    private Integer priority;

    /**
     * 分类描述
     */
    @Length(max = 50, message = "the length of description cannot over 50")
    @TableField(value = "classification_description")
    private String classificationDescription;

    /**
     * 默认类型 0:否 1:是
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

