package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;


/**
 * 移动应用/作业管理表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("t_mobile_datasource_info")
public class MobileDatasourceInfo extends BaseEntity<MobileDatasourceInfo> implements Serializable {
    private static final long serialVersionUID = 791829292787947929L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 图标
     */
    @TableField(value="icon")
    private String icon;

    /**
     * 图标类型：0-图标库、1-自定义
     */
    @TableField(value = "icon_type")
    private Integer iconType;

    /**
     * sso应用主键id
     */
    @TableField(value = "application_primary_id")
    private String applicationPrimaryId;

    /**
     * sso应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口
     */
    @TableField(value = "application_source")
    private Integer applicationSource;

    /**
     * 类型：1-第三方应用/作业 2-鼎捷非雅典娜新应用 3-鼎捷雅典娜应用
     */
    @TableField(value = "type")
    private Integer type;

    /**
     * 分类id
     */
    @TableField(value = "classification_id")
    private Long classificationId;

    /**
     * 状态：0-未启用；1-已启用
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 备注
     */
    @TableField(value = "remarks")
    private String remarks;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 作业回调地址
     */
    @TableField(value="call_back_url",updateStrategy = FieldStrategy.IGNORED)
    @Length(max = 100, min = 0, message = "callBackUrl should be within 100 characters in length")
    private String callBackUrl;


    /**
     * 是否需要自定义作业（0：不需要；1：需要）
     */
    @TableField(value="is_job")
    private Integer isJob;

    /**
     * 作业code
     */
    @TableField(value="work_code",updateStrategy = FieldStrategy.IGNORED)
    private String workCode;

    /**
     * 创建日期
     */
    @TableField(value="create_time")
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time")
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id")
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id")
    protected String modifyUserId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    private String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    private String modifyUserName;

    /**
     * 应用配置（SSO配置）
     */
    @TableField(value="application_config")
    private String applicationConfig;

    /**
     * 特殊标识：1-绿色智机 2-每刻
     */
    @TableField(value="special_sign")
    private Integer specialSign;

    /**
     * iam关联商品id
     */
    @TableField(value="iam_application_id")
    private String iamApplicationId;

    /**
     * iam关联模组id
     */
    @TableField(value="iam_module_id")
    private String iamModuleId;

    /**
     * iam关联作业id
     */
    @TableField(value="iam_work_id")
    private String iamWorkId;
}
