package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;


/**
 * 绿色智机数据迁移到 移动应用/作业管理
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("t_mobile_datasource_preset")
public class MobileDatasourcePreset extends BaseEntity<MobileDatasourcePreset> implements Serializable {
    private static final long serialVersionUID = 791829292787947929L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模组名称
     */
    @TableField(value = "module_name")
    private String moduleName;

    /**
     * 作业名称
     */
    @TableField(value = "job_name")
    private String jobName;

    /**
     * 图标
     */
    @TableField(value="icon")
    private String icon;

    /**
     * 分类名称
     */
    @TableField(value = "classification_name")
    private String classificationName;



    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 应用配置（SSO配置）
     */
    @TableField(value="application_config")
    private String applicationConfig;

    /**
     * 特殊标识：1-绿色智机 2-每刻
     */
    @TableField(value="special_sign")
    private Integer specialSign;

    /**
     * iam关联商品id
     */
    @TableField(value="iam_application_id")
    private String iamApplicationId;

    /**
     * iam关联模组id
     */
    @TableField(value="iam_module_id")
    private String iamModuleId;

    /**
     * iam关联作业id
     */
    @TableField(value="iam_work_id")
    private String iamWorkId;
}
