package com.digiwin.athena.semc.entity.mobile;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

import java.io.Serializable;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
* 移动端预设组件表
* @TableName t_mobile_label_system_pre
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_label_system_pre")
public class MobileLabelSystemPre extends BaseEntity<MobileLabelSystemPre> implements Serializable  {

    /**
    * 主键ID
    */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
    * 预设组件名称
    */
    private String name;
    /**
    * 组件分类（ 0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件；）
    */
    private Integer dataCategory;

    /**
    * 有效状态 0:无效 1:有效
    */
    private Integer validStatus;

    /**
    * 是否需要卡死状态为有效（0：不需要；1：需要）
    */
    private Integer isEnableTrue;

    /**
    * 是否需要选择数据源（0：不需要；1：需要）
    */
    private Integer isUseData;

    /**
    * 租户id
    */
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;
}
