package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("t_mobile_portal_info")
public class MobilePortalInfo  extends BaseEntity<MobilePortalInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 默认门户（ 0：否 1：是）
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    @TableField(value = "portal_type")
    private Integer portalType;


    /**
     * 自定义页面标题
     */
    @TableField(value = "title")
    private String title;


    /**
     * 自定义页面背景色
     */
    @TableField(value = "bg_color")
    private String bgColor;


    /**
     * 门户名称
     */
    @TableField(value = "name")
    @NotBlank(message = "the name cannot be empty")
    @Length(max = 30, min = 1, message = "the name Within 30 characters in length")
    private String name;

    /**
     * 自定义页面布局内容
     */
    @TableField(value = "portal_content")
    private String portalContent;

    /**
     * 布局描述
     */
    @TableField(value = "portal_desc")
    @Length(max = 100, min = 0, message = "the desc Within 100 characters in length")
    private String portalDesc;

    /**
     * 布局状态（0：未发布；1：已发布
     */
    private Integer status;


    /**
     * 缩略图文件id
     */
    @TableField(value = "portal_img_id")
    private String portalImgId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;
    /**
     * 页面组件
     */
    @TableField(exist = false)
    private List<MobilePortalInfoContent> contentList;

    /**
     * 缩略图地址
     */
    @TableField(exist = false)
    private String portalImgUrl;

    /**
     * 是否是老移动门户 true：是 false：否
     */
    @TableField(exist = false)
    private Boolean oldPortalFlag;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    @TableField(exist = false)
    private Integer portalTypeSource;

    /**
     * 门户设计时Id
     */
    @TableField(exist = false)
    private Long portalDesignerId;

    /**
     * 老门户版本为0 默认门户版本为1
     */
    @TableField(exist = false)
    private int versionDefault;
}
