package com.digiwin.athena.semc.entity.mobile;

import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* 移动门户权限关系表
* @TableName t_mobile_portal_info_auth
*/

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_portal_info_auth")
public class MobilePortalInfoAuth extends BaseEntity<MobilePortalInfoAuth> implements Serializable {

    /**
    * 主键
    */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
    * 权限对象id
    */

    private Long authId;
    /**
    * 权限对象名称
    */
    private String authName;

    /**
    * 权限类型：1.组织 2.角色 3.用户
    */
    private Integer authType;

    /**
    * 移动门户ID
    */
    private Long mobilePortalId;

    /**
    * 租户id
    */
    private String tenantId;

}
