package com.digiwin.athena.semc.entity.mobile;

import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.dto.mobile.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* 	金刚区相关字段：
 *
 * 	is_name_show  是否显示文字（0：隐藏，1：显示）
 * 	interaction_type 0：默认，金刚区内容在单页全部展开 1：左右滑动,金刚区内容支持左右滑动  2:折叠展开,金刚区部分内容展示收起，点击则展开
 *     custom_type 0:默认 租户自定义类型，1:用户自定义类型
 *     column_num 列数
 * 	line_num 行数
 *
 * 	金刚球相关字段：
 * 	content_icon 金刚球图标
 *     jump_type 金刚球跳转类型（0-常用功能、1-自定义链接、2：数据源）
 *     jump_target 金刚球跳转目标（pageID的值 或者 链接地址）
 *     custom_application_id 自定义应用id
 *
 * 	content_attr
 * 	    轮播图：
 * 		 轮播图高度模式（ 0:默认、1：低、2：高、3：自定义）：heightModel
 * 		 高度：height
 * 		    图片类型（0：模板库选择、1：本地上传）：imgType
 * 		    模板库图标或者图片ID：contentIcon
 * 		    跳转类型（0-常用功能、1-自定义链接、2：应用-作业）:jumpType
 *          跳转目标（pageID的值 或者 链接地址）：jumpTarget
 *          应用-作业id：customApplicationId
 *
 * 		公告：
 * 		 公告样式（0：有图、1：无图）：newsModel
 * 		 是否显示发布时间（0：否、1：是）： publishTimeFlag
 * 		 是否显示阅读数量（0：否、1：是）： readNumFlag
 *
 *      标题组件信息：
 * 		    展示图标（0：不展示；1：展示）：iconFlag
 * 		    图标样式（0：色块、1：图标）：iconStyle
 * 		    色块：iconColor
 * 		    图片类型（0：模板库选择、1：本地上传）：iconType
 * 		    图标相对地址或者文件全量地址：iconUrl
 * 		    图标或者图片文件ID：icon
 *          主标题文字：mainTitleName
 * 		    主标题颜色：mainTitleColor
 *          副标题文字：subTitleName
 *          副标题颜色：subTitleColor
 * 		    显示链接（0：不展示；1：展示）：linkFlag
 * 		    链接文字：linkName
 * 		    链接颜色：linkColor
 * 		    跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告）:jumpType
 *          跳转目标（pageID的值 或者 链接地址）：jumpTarget
 * 		    应用/作业Id：customApplicationId
 *
 * 	    分割线：
 * 		    高度：height
 * 		    背景色： backgroundColor
 * 		    线条样式 （0：实线 1：虚线 2：点线 3：无）： lineStyleFlag
 * 		    线条颜色：lineColor
 *
 * 	图片组件 imageCompInfo：
 * 	    图片ID：imageId
 * 		图片url：imageUrl
 * 		热区信息：hotZoneList
 * 		   跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告）:jumpType
 *            跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID）：jumpTarget
 * 		   应用/作业Id：customApplicationId
 * 		   热区坐标：coordinate
 *
 * 	业务入口 businessCompInfo：
 * 	   业务样式：busStyle
 * 	   背景色：busBgColor
 * 	   图片集合：imageList
 * 	      图片ID：imageId
 * 		  图片url：imageUrl
 * 		  跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告）:jumpType
 *        跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID）：jumpTarget
 * 		  应用/作业Id：customApplicationId
 *
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_portal_info_content")
public class MobilePortalInfoContent extends BaseEntity<MobilePortalInfoContent> implements Serializable {

    /**
    * 主键ID
    */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 上级ID
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
    * 门户ID
    */
    @TableField(value = "mobile_portal_id")
    private Long mobilePortalId;


    /**
     * 内容uuid，相同组件uuid不同
     */
    @TableField(value="content_uuid")
    private String contentUuid;

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    @TableField(exist = false)
    private Integer labelTypeSource;

    /**
    * 组件ID
    */
    @TableField(value = "content_id")
    private Long contentId;

    /**
    * 组件类型（0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、3-金刚球、4：轮播图、5：公告
     * 、6：标题、7：分割线、8：三方待办、9：图片、10：业务入口）
    */
    @TableField(value = "content_type")
    private Integer contentType;

    /**
    * 内容组件名称
    */
    @TableField(value = "content_name")
    private String contentName;

    /**
     * 金刚球图标类型 0:模板库 1:本地上传
     */
    @TableField(value = "icon_type")
    private Integer iconType;

    /**
    * 金刚球图标或文件id
    */
    @TableField(value = "content_icon")
    private String contentIcon;

    /**
     * 金刚球跳转链接
     */
    @TableField(value = "icon_url")
    private String iconUrl;

    /**
     * 组件内容属性值json
     */
    @TableField(value = "content_attr")
    private String contentAttr;

    /**
    * 金刚球跳转类型（0-常用功能、1-自定义链接、2：应用/作业、3：自定义页面、4：公告 5、公告类型_0表示全部公告）
    */
    @TableField(value = "jump_type")
    private Integer jumpType;

    /**
    * 金刚球跳转目标（pageID的值 或者 链接地址 或者自定义页面ID 或者 公告ID 或者公告类型ID）
    */
    @TableField(value = "jump_target")
    private String jumpTarget;

    /**
    * 是否显示文字（0：隐藏，1：显示）
    */
    @TableField(value = "is_name_show")
    private Integer isNameShow;

    /**
     *0：默认，金刚区内容在单页全部展开 1：左右滑动,金刚区内容支持左右滑动  2:折叠展开,金刚区部分内容展示收起，点击则展开
     */
    @TableField(value = "interaction_type")
    private Integer interactionType =0;

    /**
     * 0:默认 租户自定义类型，展示原来的金刚区,1:用户自定义类型
     */
    @TableField(value = "custom_type")
    private Integer customType =0;

    /**
     * 列数
     */
    @TableField(value = "column_num")
    private Integer columnNum;

    /**
     * 行数
     */
    @TableField(value = "line_num")
    private Integer lineNum;

    /**
    * 租户id
    */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 金刚球信息
     */
    @TableField(exist = false)
    private List<MobilePortalInfoContent> ballList;

    /**
     * 金刚球名称
     */
    @TableField(exist = false)
    private String ballName;

    /**
     * 自定义应用id
     */
    @TableField(value = "custom_application_id")
    private Long  customApplicationId;


    /**
     * 公告信息
     */
    @TableField(exist = false)
    private MobilePortalContentNews newsInfo;


    /**
     * 轮播图信息
     */
    @TableField(exist = false)
    private MobilePortalContentCarousel carouselInfo;

    /**
     * 标题组件信息
     */
    @TableField(exist = false)
    private MobilePortalTitleInfoReqDTO titleInfo;

    /**
     * 分割线信息
     */
    @TableField(exist = false)
    private MobilePortalDividerInfoReqDTO dividerInfo;


    /**
     * 图片组件
     */
    @TableField(exist = false)
    private MobilePortalImageInfoReqDTO imageCompInfo;


    /**
     * 业务入口组件
     */
    @TableField(exist = false)
    private MobilePortalBusinessInfoReqDTO businessCompInfo;

    /**
     * 组件内容信息
     * 公告信息:MobilePortalContentNews
     * 轮播图信息:MobilePortalContentCarousel
     * 标题组件信息:MobilePortalTitleInfoReqDTO
     * 分割线信息:MobilePortalDividerInfoReqDTO
     * 图片组件:MobilePortalImageInfoReqDTO
     * 业务入口组件:MobilePortalBusinessInfoReqDTO
     * 金刚区组件：PortalContentKingKongDistrict
     */
    @TableField(exist = false)
    private Object contentConfig;
}
