package com.digiwin.athena.semc.entity.mobile;


import javax.validation.constraints.Size;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.Length;

/**
* 用户选择移动门户记录表
* @TableName t_mobile_portal_info_use
*/

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_portal_info_use")
public class MobilePortalInfoUse extends BaseEntity<MobilePortalInfoUse> implements Serializable {

    /**
    * 主键
    */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
    * 移动门户ID
    */
    private Long mobilePortalId;

    /**
    * 租户id
    */
    private String tenantId;

    /**
     * 门户名称
     */
    private String name;

}
