package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * 移动门户预览表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("t_mobile_portal_preview")
@AutoMapper(target = MobilePortalInfo.class)
public class MobilePortalPreview extends BaseEntity<MobilePortalPreview> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 默认门户（ 0：否 1：是）
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 门户ID
     */
    private Long mobilePortalId;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    @TableField(value="portal_type_source")
    private Integer portalTypeSource;

    /**
     * 门户名称
     */
    @TableField(value = "name")
    private String name;


    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    @TableField(value = "portal_type")
    private Integer portalType;


    /**
     * 自定义页面标题
     */
    @TableField(value = "title")
    private String title;


    /**
     * 自定义页面背景色
     */
    @TableField(value = "bg_color")
    private String bgColor;

    /**
     * 布局描述
     */
    @TableField(value = "portal_desc")
    private String portalDesc;

    /**
     * 布局状态（0：未发布；1：已发布
     */
    private Integer status;


    /**
     * 缩略图文件id
     */
    @TableField(value = "portal_img_id")
    private String portalImgId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;

    /**
     * 二维码失效时间
     */
    @TableField(value="end_time")
    protected Date endTime;



    /**
     * 布局内容集合jsonList
     */
    @TableField(value="portal_content_list")
    protected String portalContentList;

    /**
     * 页面组件
     */
    @TableField(exist = false)
    private List<MobilePortalInfoContent> contentList;

    @TableField(value = "version_default")
    private Integer versionDefault;
}
