package com.digiwin.athena.semc.entity.mobile;

import javax.validation.constraints.NotNull;

import java.io.Serializable;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
* 用户最新选择的移动门户类型
* @TableName t_mobile_portal_type_use
*/

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder

@TableName("t_mobile_portal_type_use")
public class MobilePortalTypeUse extends BaseEntity<MobilePortalTypeUse> implements Serializable {

    /**
    * 主键
    */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
    * 用户最新选择的移动门户类型（0：旧、1：新门户）
    */
    @NotNull(message="[用户最新选择的移动门户类型（0：旧、1：新门户）]不能为空")
    private Integer portalType;

    /**
     * 用户选择的门户id
     */
    @TableField(exist = false)
    private Long  mobilePortalId;

    /**
    * 租户id
    */
    private String tenantId;

    /**
     * 门户名称
     */
    @TableField(exist = false)
    private String portalName;
}
