package com.digiwin.athena.semc.entity.mobile;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * App启动页配置表
 */
@Data
@TableName(value="t_mobile_start_set")
public class MobileStartSet extends BaseEntity<MobileStartSet> implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模板库中图片ID
     */
    @TableField(value="pic_id",updateStrategy = FieldStrategy.IGNORED)
    private String picId;

    /**
     * 图片url,简体
     */
    @TableField(value="pic_url",updateStrategy = FieldStrategy.IGNORED)
    private String picUrl;

    /**
     * 图片url,繁体
     */
    @TableField(value="pic_url_tw",updateStrategy = FieldStrategy.IGNORED)
    private String picUrlTw;

    /**
     * 图片url,英文
     */
    @TableField(value="pic_url_us",updateStrategy = FieldStrategy.IGNORED)
    private String picUrlUs;

    /**
     * 本地上传图片ID
     */
    @TableField(value="pic_local_id",updateStrategy = FieldStrategy.IGNORED)
    private String picLocalId;

    /**
     * 文件修改时间戳
     */
    @TableField(value="change_time",updateStrategy = FieldStrategy.IGNORED)
    private String changeTime;

    /**
     * 本地上传图片地址
     */
    @TableField(exist = false)
    private String picLocalUrl;

    /**
     * 图片类型（0：模板库选择、1：本地上传）
     */
    @NotNull(message = "the imgType cannot be empty")
    private Integer imgType;

    /**
     * 设备类型（0：手机、1：平板）
     */
    @NotNull(message = "the deviceType cannot be empty")
    private Integer deviceType;


    /**
     * 租户id
     */
    private String tenantId;
}