package com.digiwin.athena.semc.entity.module;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description: 模块信息
 * @createDate: 2025/8/25 16:45
 * @author: lilliaancheng
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_module_info")
public class ModuleInfo implements Serializable {
    /** 主键 */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 模块编码 */
    @TableField(value = "module_code")
    private String moduleCode;

    /** 作业编码 */
    @TableField(value = "code")
    private String code;

    /** 分组编码 */
    @TableField(value = "group_code")
    private String groupCode;

    /** 应用编码 */
    @TableField(value = "app_code")
    private String appCode;

    /** 作业排序 */
    @TableField(value = "item_sort")
    private Integer itemSort;

    /** 分组排序 */
    @TableField(value = "group_sort")
    private Integer groupSort;

    /** 应用排序 */
    @TableField(value = "app_sort")
    private Integer appSort;

    /** 租户ID */
    @TableField(value = "tenant_id")
    private String tenantId;


}
