package com.digiwin.athena.semc.entity.news;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 新闻公告表(TNewsAnnouncement)实体类
 *
 * @author sunqgz
 * @since 2024-05-13
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_news_announcement")
public class NewsAnnouncement extends BaseEntity<NewsAnnouncement> implements Serializable {
    private static final long serialVersionUID = -43812213060625880L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 公告标题
     */
    @TableField(value = "news_title")
    private String newsTitle;

    /**
     * 公告状态 0:未发布 1:已发布 2:已失效 3:待生效(该状态在代码中体现)
     */
    @TableField(value = "news_status")
    private Integer newsStatus;

    /**
     * 公告生效时间类型 0:立即生效 1:定时生效
     */
    @TableField(value = "news_effective_flag")
    private Integer newsEffectiveFlag;

    /**
     * 公告生效时间
     */
    @TableField(value = "news_effective_time")
    private String newsEffectiveTime;

    /**
     * 公告截止时间
     */
    @TableField(value = "news_end_time")
    private String newsEndTime;

    /**
     * 公告类型id
     */
    @TableField(value = "news_type_id")
    private Long newsTypeId;

    /**
     * 公告类型路径
     */
    @TableField(value = "news_type_path")
    private String newsTypePath;

    /**
     * 公告类型名称
     */
    @TableField(exist = false)
    private String newsTypeName;

    /**
     * 公告摘要
     */
    @TableField(value = "summary")
    private String summary;

    /**
     * 公告渠道标识 0:全部 1:Web工作台 2:移动工作台
     */
    @TableField(value = "news_channel")
    private Integer newsChannel;

    /**
     * 封面图默认icon
     */
    @TableField(value = "default_image_icon")
    private String defaultImageIcon;

    /**
     * 封面图文件id
     */
    @TableField(value = "cover_image_id")
    private String coverImageId;

    /**
     * 是否置顶 0:否 1:是
     */
    @TableField(value = "topped_flag")
    private Integer toppedFlag;

    /**
     * 公告置顶时间
     */
    @TableField(value = "topped_time", updateStrategy = FieldStrategy.IGNORED)
    private String toppedTime;

    /**
     * 是否修改 0:否 1:是
     */
    @TableField(value = "modified_flag")
    private Integer modifiedFlag;

    /**
     * 是否发送工作提醒 0：否 1：是
     */
    @TableField(value = "notice_flag")
    private Integer noticeFlag;

    /**
     * 是否已经发送过工作提醒 0：否 1：是
     */
    @TableField(value = "already_notice_flag")
    private Integer alreadyNoticeFlag;

    /**
     * 公告正文
     */
    @TableField(value = "news_content")
    private String newsContent;

    /**
     * 附件id，以英文逗号分隔
     */
    @TableField(value = "file_id")
    private String fileId;

    /**
     * 公告已读人员数
     */
    @TableField(value = "read_count")
    private Integer readCount;

    /**
     * 公告点赞人员数
     */
    @TableField(value = "like_count")
    private Integer likeCount;

    /**
     * 公告收藏人员数
     */
    @TableField(value = "favorite_count")
    private Integer favoriteCount;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 三方公告id
     */
    @TableField(value = "third_news_id")
    private String thirdNewsId;

    /**
     * 三方应用id
     */
    @TableField(value = "third_app_id")
    private String thirdAppId;

    /**
     * 三方应用code
     */
    @TableField(value = "third_app_code")
    private String thirdAppCode;

    /**
     * 三方应用类型，1：BS，2：CS，3：预设
     */
    @TableField(value = "third_app_type")
    private Integer thirdAppType;

    /**
     * 三方图片url
     */
    @TableField(value = "third_img_url")
    private String thirdImgUrl;

    /**
     * 域名
     */
    @TableField(value = "third_url")
    private String thirdUrl;

    /**
     * 三方人员通知列表 如  emp001.emp002
     */
    @TableField(value = "third_user_ids")
    private String thirdUserIds;

    /**
     * 消息来源 0：一方 1：三方
     */
    @TableField(value = "news_source")
    private Integer newsSource;

    /**
     * 三方新闻页面
     */
    @TableField(value = "third_news_html")
    private String thirdNewsHtml;

    /**
     * 注册应用时生成的appId
     */
    @TableField(exist = false)
    private String applicationAppId;

    /**
     * 消息来源应用名称
     */
    @TableField(exist = false)
    private String messageAppName;

    /**
     * 回调地址
     */
    @TableField(exist = false)
    private String callBackUrl;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    @TableField(exist = false)
    private Integer protocolType;

    /**
     * appToken
     */
    @TableField(exist = false)
    private String appToken;

    /**
     * flag =0 代表截止时间小于当前 ，flag = 1 代表 等于截止时间 flag = 2 代表截止时间大于当前
     */
    @TableField(exist = false)
    private Integer flag;


    /**
     * 发布人类型，1（无）， 2（发布人姓名） 3（发布人角色）
     */
    @TableField(value = "publish_type")
    private Integer publishType;

    /**
     * 发布人id（当publishType为3时必填）
     */
    @TableField(value = "publish_id")
    private String publishId;


    /**
     * 发布人姓名
     */
    @TableField(value = "publish_name")
    private String publishName;

}



