package com.digiwin.athena.semc.entity.news;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 新闻公告权限表(TNewsAnnouncementAuth)实体类
 *
 * @author sungqz
 * @since 2024-05-14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_news_announcement_auth")
public class NewsAnnouncementAut extends BaseEntity<NewsAnnouncementAut> implements Serializable {
    private static final long serialVersionUID = -28142494855273317L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 公告id
     */
    @TableField(value = "news_id")
    private Long newsId;

    /**
     * 公告类型id
     */
    @TableField(value = "news_type_id")
    private Long newsTypeId;

    /**
     * 全员可见 0:否 1:是
     */
    @TableField(value = "all_auth_flag")
    private Integer allAuthFlag;

    /**
     * 权限对象id
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限业务id
     */
    @TableField(value = "auth_biz_id")
    private String authBizId;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户 5.部门
     */
    @TableField(value = "auth_type")
    private Integer authType;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 创建者租户id
     */
    @TableField(value = "create_tenant_id")
    private String createTenantId;
}

