package com.digiwin.athena.semc.entity.news;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 新闻公告已读表(TNewsAnnouncementRead)实体类
 *
 * @author sungqz
 * @since 2024-05-15
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_news_announcement_read")
public class NewsAnnouncementRead extends BaseEntity<NewsAnnouncementRead> implements Serializable {
    private static final long serialVersionUID = -67250304958270989L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 公告id
     */
    @TableField(value = "news_id")
    private Long newsId;

    /**
     * 三方公告id
     */
    @TableField(value = "third_news_id")
    private String thirdNewsId;

    /**
     * 三方应用code
     */
    @TableField(value = "third_app_code")
    private String thirdAppCode;

    /**
     * 三方应用id
     */
    @TableField(value = "third_app_id")
    private String thirdAppId;

    /**
     * 创建者sid
     */
    @TableField(value = "create_user_sid")
    private Long createUserSid;

    /**
     * 创建者名称
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 三方账号id
     */
    @TableField(value = "third_user_id")
    private String thirdUserId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

