package com.digiwin.athena.semc.entity.news;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.io.Serializable;

/**
 * 新闻公告类型表(TNewsAnnouncementType)实体类
 *
 * @author sungqz
 * @since 2024-05-13
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_news_announcement_type")
public class NewsAnnouncementType extends BaseEntity<NewsAnnouncementType> implements Serializable {
    private static final long serialVersionUID = 791829292787947929L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 公告类型标题
     */
    @NotBlank(message = "the name cannot be null")
    @Length(max = 10, message = "the length of name cannot over 10")
    @TableField(value = "name")
    private String name;

    /**
     * 公告类型标题-繁体
     */
    @TableField(value = "name_tw")
    private String nameTw;

   /**
     * 公告类型层级
     */
   @Range(min = 1, max = 2, message = "level is illegal")
   @TableField(value = "level")
    private Integer level;

    /**
     * 公告类型顺序
     */
    @Range(min = 1, max = 99999, message = "menuType is illegal")
    @TableField(value = "sort")
    private Integer sort;

    /**
     * 公告总数
     */
    @TableField(value = "news_count")
    private Integer newsCount;

    /**
     * 已发布公告总数
     */
    @TableField(value = "published_news_count")
    private Integer publishedNewsCount;

    /**
     * 父类型id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 公告类型说明
     */
    @Length(max = 50, message = "the length of description cannot over 50")
    @TableField(value = "description")
    private String description;

    /**
     * 公告类型说明-繁体
     */
    @TableField(value = "description_tw")
    private String descriptionTw;

    /**
     * 默认类型 0:否 1:是
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

