package com.digiwin.athena.semc.entity.news;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 公告类型权限表 实体类
 *
 * @author sungqz
 * @since 2025-01-10
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_news_announcement_type_auth")
public class NewsAnnouncementTypeAuth extends BaseEntity<NewsAnnouncementTypeAuth> implements Serializable {

    private static final long serialVersionUID = 385781180270931468L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 权限对象id
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户 4.外部用户 5.部门
     */
    @TableField(value = "auth_type")
    private Integer authType;

    /**
     * 全部类型标识 0:否 1:是
     */
    @TableField(value = "all_news_type_flag")
    private Integer allNewsTypeFlag;

    /**
     * 公告类型id
     */
    @TableField(value = "news_type_id")
    private Long newsTypeId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}

