package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * @description 行为功能映射表
 * @author: sungqz
 * @create: 2023-4-21
 */
@Data
@TableName(value = "action_function_mapping")
public class ActionFunctionMapping extends BaseEntity<ActionFunctionMapping> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 行为id
     */
    private String actionId;

    /**
     * 行为名称
     */
    private String actionName;

    /**
     * 功能标识
     */
    private String functionKey;

    /**
     * 功能描述
     */
    private String functionDesc;

    /**
     * 功能入口 0：前端 1：后端
     */
    private Integer functionSide;
}