package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@TableName(value = "workbench_app_custom_setting")
public class AppCustomSetting implements Serializable {
    private static final long serialVersionUID = -1L;
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台应用code
     */
    @TableField(value = "application")
    private String application;

    /**
     * 定制包名称
     */
    @TableField(value = "package_name")
    private String packageName;

    /**
     * 定制包打包后的入口文件名称
     */
    @TableField(value = "remote_entry")
    private String remoteEntry;

    /**
     * 微前端中被导入的模块名称
     */
    @TableField(value = "remote_name")
    private String remoteName;

    /**
     * 微前端中被导出的模块路径
     */
    @TableField(value = "exposed_module")
    private String exposedModule;

    /**
     * 微前端中被导出的模块名称
     */
    @TableField(value = "module_name")
    private String moduleName;

    @TableField(value = "version")
    private String version;

    @TableField(value = "designer_id")
    private Long designerId;

    @TableField(value = "source")
    private Integer source;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time", fill = FieldFill.INSERT_UPDATE)
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String modifyUserId;
}
