package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @description: 帆软报表对象
 * @createDate: 2023/5/26 9:17
 * @author: sunyfa
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_fine_report")
public class FineReport extends BaseEntity<FineReport> implements Serializable {
    /** 主键 */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 报表名称 */
    @TableField(value = "name")
    private String name;

    /** 报表链接 */
    @TableField(value = "`url`")
    private String url;

    /** 描述 */
    @TableField(value = "comments")
    private String comments;

    /** 目录标识 */
    @TableField(value = "folder_id")
    private Long folderId;

    /** 报表顺序 */
    @TableField(value = "report_order")
    private Integer reportOrder;

    /** 是否配置人员 0:否; 1:是 */
    @TableField(value = "user_config_flag")
    private Integer userConfigFlag;

    /** 配置的部门标识 1：一级部门 2：二级部门 3：三级部门 */
    @TableField(value = "department_config_flag")
    private Integer departmentConfigFlag;

    /** 配置的工厂名称 */
    @TableField(value = "factory_config_name")
    private String factoryConfigName;
}