package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 待办列表(TodoList)实体类
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
@Data
@TableName(value = "t_portal_knowledge_application")
public class KnowledgeApplicationRef extends BaseEntity<KnowledgeApplicationRef>  implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    @TableId(type = IdType.AUTO)
    private Long id;


    @TableField(value = "knowledge_id")
    private String knowledgeId;


    @TableField(value = "application_id")
    private String applicationId;

    @TableField(value = "app_primary_id")
    private String appPrimaryId;

    @TableField(value = "is_enable")
    @JsonIgnore
    private Integer isEnable;

    @TableField(value = "tenant_id")
    private String tenantId;

    @TableField(value = "modify_user_name")
    private String modifyUserName;

    @TableField(value = "create_user_name")
    private String createUserName;

    @TableField(value = "application_source")
    private Integer applicationSource;

    @TableField(value = "application_type")
    private Integer applicationType;
}
