package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 首页标签实体类
 */
@Data
@TableName(value = "t_homepage_label")
public class Label extends BaseEntity<Label> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 系统标识 0:智驱 1:非智驱
     */
    @TableField(value="system_flag")
    private Integer systemFlag;

    /**
     * 标签唯一标识
     */
    @TableField(value="label_key")
    private String labelKey;

    /**
     * 标签名称
     */
    @TableField(value="label_name")
    private String labelName;

    /**
     * 图片url
     */
    @TableField(value="in_pic_url")
    private String inPicUrl;

    /**
     * 图片url
     */
    @TableField(value="out_pic_url")
    private String outPicUrl;

    /**
     * 简体标题
     */
    @TableField(value="title_cn")
    private String titleCn;

    /**
     * 繁体标题
     */
    @TableField(value="title_tw")
    private String titleTw;

    /**
     * 英文标题
     */
    @TableField(value="title_us")
    private String titleUs;

    /**
     * 副标题
     */
    @TableField(value="sub_title")
    private String subTitle;

    /**
     * 生效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;
}