package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.sso.ErpSsoInfo;
import com.digiwin.athena.semc.entity.sso.ThirdSsoInfo;
import lombok.Data;

import java.io.Serializable;

/**
 * 组件应用系统 实体
 */
@Data
@TableName(value = "t_label_system")
public class LabelSystem extends BaseEntity<LabelSystem> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 组件id
     */
    @TableField(value="label_id")
    private Long labelId;

    /**
     * 页签标识
     */
    @TableField(value="tab_flag")
    private String tabFlag;

    /**
     * 页签名称
     */
    @TableField(value="tab_name")
    private String tabName;

    /**
     * 应用系统名称
     */
    @TableField(value="system_name")
    private String systemName;

    /**
     * 地中台系统名称
     */
    @TableField(value="middle_system_name")
    private String middleSystemName;

    /**
     * 地中台系统uid
     */
    @TableField(value="middle_system_uid")
    private String middleSystemUid;

    /**
     * 系统标识 wt:稳态 mt:敏态
     */
    @TableField(exist = false)
    private String systemType;

    /**
     * 敏态配置信息
     */
    @TableField(exist = false)
    private ThirdSsoInfo thirdSsoInfo;

    /**
     * 稳态配置信息
     */
    @TableField(exist = false)
    private ErpSsoInfo erpSsoInfo;
}