package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.configuration.MySqlMapHandler;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import lombok.Data;
import org.apache.ibatis.type.JdbcType;

import java.io.Serializable;
import java.util.Map;

/**
 * 自定义组件表实体
 */
@Data
@TableName(value = "t_label_system_custom")
public class LabelSystemCustom extends BaseEntity<LabelSystemCustom> implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台自定义部件设计时id
     */
    @TableField(value = "component_designer_id")
    private Long componentDesignerId;

    /**
     * 工作台应用code
     */
    @TableField(value = "workbench_app_code")
    private String workbenchAppCode;

    /**
     * 自定义组件名称-中文
     */
    @TableField(value = "name_zh")
    private String nameZh;

    /**
     * 自定义组件名称-英文
     */
    @TableField(value = "name_us")
    private String nameUs;

    /**
     * 图标
     */
    @TableField(value = "icon")
    private String icon;

    /**
     * 经典门户图标
     */
    @TableField(value = "classics_icon")
    private String classicsIcon;

    /**
     * 组件分类
     * pc端（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办、8-自定义组件-内嵌网页、9-自定义组件-报表 10-自定义组件-低代码）；
     * 移动端：（ 11-自定义组件-H5外链）
     */
    @TableField(value = "data_category")
    private Integer dataCategory;

    /**
     * 内容
     */
    @TableField(value = "content")
    private String content;

    /**
     * 组件端 0：PC端，1：移动端
     */
    @TableField(value = "client_type")
    private Integer clientType;

    /**
     * 内嵌网页-组件类型 链接地址
     */
    @TableField(value = "link_url")
    private String linkUrl;

    /**
     * 内嵌网页-组件类型 链接配置
     */
    @TableField(value = "link_param")
    private String linkParam;

    /**
     * 展示方式（ 0：文本列表、1：应用、2：应用作业）
     */
    @TableField(value = "show_type")
    private Integer showType;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value = "valid_status")
    private Integer validStatus;

    /**
     * 自定义组件备注
     */
    @TableField(value = "remark")
    private String remark;
    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 数据版本
     */
    @TableField(value = "version")
    private String version;

    /**
     * 编译版本，可选
     */
    @TableField(value = "compile_version")
    private String compileVersion;

    /**
     * 创建者登录名称
     */
    @TableField(value = "create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value = "modify_user_name")
    protected String modifyUserName;

    /**
     * 多语言
     */
    @TableField(value = "lang")
    private Map<String, MultiLanguageDTO> lang;

    /**
     * ISV客制部件的脚本
     */
    @TableField(value = "content_config", typeHandler = MySqlMapHandler.class, jdbcType = JdbcType.LONGVARCHAR)
    private Map<String, Object> contentConfig;

    @TableField(value = "source")
    private Integer source;
}